﻿using System.Data;

public class PatientRepository
{
    private const string CONNECT_STRING_NAME = "RegistryConnectionString";
    private const string USP_GET_STATION_NUMBER_FOR_PATIENT = "[EFR].[usp_GetStationNumberForPatient]";

    internal string GetStationNumberForPatient(int patientId)
    {
        using (var dt = SqlProvider.ExecuteSPDataTable(
            CONNECT_STRING_NAME,
            USP_GET_STATION_NUMBER_FOR_PATIENT,
            new[] { string.Format("{0}", patientId) }))
        {
            if (dt != null
                && dt.Rows != null
                && dt.Rows.Count > 0)
            {
                return dt.Rows[0].Field<string>("stationnumber");
            }
        }

        return null;
    }
}